import numpy as np
import data.energy_pdf_all_normalized
import data.oracle_access
from data.energy_pdf_all_normalized import *

def generateConsumptionArrayTrace(
	models = [0,4,5]
):
	consumptionArray = []
	for m in models:
		pmf = np.array(data.energy_pdf_all_normalized.generatePMFforModel(m))
		consumptionArray.append(np.concatenate((np.array([0]),pmf)))
	return np.array(consumptionArray)

def generateOracle(
		T:int,
		models = [0,4,5]

):
	valueOracle = []
	donothingValueOracle = []
	consumptionOracle = []
	value, consumption, doNothing = data.oracle_access.generateOracle()

	start = 0
	end = start+T
	for model in models:
		valueOracle.append(np.array(value[model])[start:end])
		donothingValueOracle.append(np.array(doNothing[model])[start:end])
		consumptionOracle.append(consumption[model])
	return np.array(valueOracle),np.array(donothingValueOracle),np.array(consumptionOracle)

